var Presenter = {
    /*
    navigationDocument controls the view stack: One can push, pop, and present TVML documents

    * insertBeforeDocument: Insert a specified document before a document currently on stack
    * pushDocument: Push a specified document onto the stack
    * replaceDocument: Replaces a document currently on the stack with the specified document

    * dismissModal: Dismisses the currently displayed document. The previous document is brought into focus.
    * presentModal: Displays the passed document on top of current document (if any)

    */
    getDocument: function(XMLString) {
        if (!Presenter.parser) {
            Presenter.parser = new DOMParser();

            var doc = Presenter.parser.parseFromString(XMLString, "application/xml");
            return doc;
        }
    },
    presentDocument: function(XMLDocument) {
        navigationDocument.presentModal(XMLDocument);
    },
    pushDocument: function(XMLDocument) {
        navigationDocument.pushDocument(XMLDocument);
    }
}
